@include('components.student-grade-report.student-grade-report-head')

<body>
    @foreach ($studentGrades as $studentGrade)
    @php
    $classRoom = $studentGrade['school_session']['class_room'] ?? null;
    @endphp

    <div class="report-card">
        <!-- header -->
        <table class="header-table">
            <tr>
                <td style="width: 25%; font-size: 10pt;">
                    کد مدرسه: {{ $reportInfo['school_code'] }}<br>
                    استان: {{ $reportInfo['school_province'] }}<br>
                    ناحیه: {{ $reportInfo['school_district'] }}
                </td>
                <td class="header-center">
                    <img class="logo-box" src="{{ public_path('storage/schools/images/logo.png') }}" />

                    <p style="margin: 0;">{{ $reportInfo['school_title'] }}</p>
                </td>
                <td style="width: 25%; font-size: 10pt; text-align: left;">
                    از تاریخ: {{ $gradeStartedAt() }}<br>
                    تا تاریخ: {{ $gradeEndedAt() }}<br>
                    نوع: {{ $reportInfo['school_type'] }}
                </td>
            </tr>
        </table>

        <!-- information -->
        <table class="student-info-table">
            <tr>
                <td style="vertical-align: middle;">
                    <strong>کد کلاس:</strong> {{ $classRoom['code'] ?? '-' }}<br><br>
                    <strong>پایه:</strong> {{ $classRoom['academic_level']['title'] ?? '-' }}<br><br>
                    <strong>رشته:</strong> {{ $classRoom['major']['title'] ?? '-' }}<br><br>
                </td>
                <td style="vertical-align: middle;">
                    <strong>نام و نام خانوادگی:</strong> {{ $fullName($studentGrade) }}<br><br>
                    <strong>نام پدر:</strong> {{ $fatherName($studentGrade) }}<br><br>
                    <strong>کد ملی:</strong> {{ $studentGrade['national_code'] ?? '-' }}<br><br>
                </td>
                <td style="text-align: left;">
                    <div class="photo-container">
                        <!-- student image -->
                        @if (isset($studentGrade['image']))
                        <img
                            class="student-photo"
                            src="{{ storage_path('app/private/students/images/'. $studentGrade['image']['name']) }}" />
                        @else
                        <img
                            class="student-photo"
                            src="{{ resource_path('assets/images/avatar.png') }}" />
                        @endif
                    </div>
                </td>
            </tr>
        </table>

        <!-- table grades-->
        <table class="grades-table">
            <thead>
                <tr>
                    <th style="width: 40px;">ردیف</th>
                    <th>کد درس</th>
                    <th>نام درس</th>
                    <th>نمره نهایی</th>
                    <th>نتیجه</th>
                    <th>اساتید</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($studentGrade['grades'] as $idx => $grade)
                <tr class={{$passingLesson($grade)?'':'failed-row'}}>
                    <td>{{ $idx + 1 }}</td>
                    <td>{{ $grade['lesson']['id'] ?? '-' }}</td>
                    <td>{{ $grade['lesson']['title'] ?? '-' }}</td>
                    <td>{{ $grade['grade'] }}</td>
                    <td>{{ $passingLesson($grade) ? 'قبول' : 'مردود'}}</td>
                    <td>{{ $teacherFullName($grade) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <div class="gpa-box">
            معدل دوره: {{ $finalGrade($studentGrade['grades']) }}
        </div>

        <!-- signature -->
        <table class="signature-table">
            <tr>
                <td>مهر و امضای معاون اجرایی</td>
                <td>مهر و امضای مدیریت آموزشگاه</td>
            </tr>
            <tr>
                <td>...........................</td>
                <td>...........................</td>
            </tr>
        </table>
    </div>
    @endforeach

</body>