<?php

use App\Http\Controllers\ClassRoomController;
use Illuminate\Support\Facades\Route;


Route::group(['prefix' => 'class-rooms'], function () {
    Route::get('', [ClassRoomController::class, 'index']);

    Route::post('', [ClassRoomController::class, 'store']);

    Route::group(['prefix' => '{id}'], function () {
        Route::get('students', [ClassRoomController::class, 'indexStudents']);

        Route::patch('', [ClassRoomController::class, 'update']);

        Route::delete('', [ClassRoomController::class, 'destroy']);
    });
});
