<?php

use App\Http\Controllers\StudentController;
use Illuminate\Support\Facades\Route;


Route::group(['prefix' => 'students'], function () {
    Route::get('', [StudentController::class, 'index']);

    Route::post('', [StudentController::class, 'store']);

    Route::get('me', [StudentController::class, 'me']);

    Route::post('excel', [StudentController::class, 'excelStore']);

    Route::patch('{id}', [StudentController::class, 'update']);

    Route::delete('{id}', [StudentController::class, 'destroy']);

    Route::get('private-storage/{dir}/{filename}', [StudentController::class, 'privateStorage'])
        ->middleware(['jwt.file']);
});
