<?php

use App\Jobs\RemoveLogJob;
use App\Jobs\TeacherPresenceJob;
use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schedule;

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');

Schedule::job(RemoveLogJob::class)
    ->dailyAt('03:00')
    ->timezone('Asia/Tehran');

Schedule::job(TeacherPresenceJob::class)
    ->everyThirtyMinutes()
    ->between('06:00', '23:00')
    ->timezone('Asia/Tehran');
