<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <style>
        @page {
            header: page-header;
            margin-top: 120px;
        }

        .header-table {
            width: 100%;
            margin-bottom: 10px;
            border-collapse: collapse;
        }

        .header-table td {
            border: none;
            padding: 2px 5px;
            font-size: 13px;
            white-space: nowrap;
        }

        .header-logo {
            max-height: 40px;
            width: auto;
            display: inline-block;
        }

        .header-title {
            text-align: center;
            font-size: 16px;
            font-weight: bold;
            padding: 10px 0;
        }

        .custom-table {
            width: 100%;
            margin: 6px auto;
            border-collapse: collapse;
            font-size: 14px;
        }

        .custom-table th {
            font-weight: 500;
            border: 1px solid #ccc;
            padding: 5px;
            text-align: center;
            vertical-align: middle;
            background-color: #f8f9fa;
        }

        .custom-table td {
            border: 1px solid #ccc;
            padding: 5px;
            text-align: right;
            vertical-align: top;
        }

        .custom-table tbody tr:nth-child(even) {
            background-color: #f2f2f2;
        }

        .long-text-column {
            font-size: 0.9em;
        }

        .time-column {
            font-size: 0.8em;
            width: 30px;
            text-align: center;
        }

        .small-column {
            width: 50px;
            text-align: center;
        }
    </style>
</head>


<body>
    <htmlpageheader name="page-header">
        <div>
            <div class="header-title">
                <?php echo e($reportInfo['school_title']); ?>

            </div>
            <table class="header-table">
                <tr>
                    <td style="width: 40%; text-align: right;">
                        از تاریخ: <?php echo e($presenceStartedAt()); ?>

                        <br>
                        تا تاریخ: <?php echo e($presenceEndedAt()); ?>

                        <br>
                        کد مدرسه: <?php echo e($reportInfo['school_code']); ?>

                    </td>

                    <td style="width: 20%; text-align: center; vertical-align: middle;">
                        <img src="<?php echo e(public_path('storage/schools/images/logo.png')); ?>"
                            class="header-logo"
                            alt="School Logo" />
                    </td>

                    <td style="width: 40%; text-align: left;">
                        نوع: <?php echo e($reportInfo['school_type']); ?>

                        <br>
                        استان: <?php echo e($reportInfo['school_province']); ?>

                        <br>
                        ناحیه: <?php echo e($reportInfo['school_district']); ?>

                    </td>
                </tr>
            </table>
        </div>
    </htmlpageheader>

    <table class="custom-table">
        <thead class="thead-dark">
            <tr>
                <th class="small-column">شناسه دانش آموز</th>
                <th>نام نام خانوادگی</th>
                <th class="time-column">ورود</th>
                <th class="time-column">خروج</th>
                <th class="long-text-column">دلیل تاخیر</th>
                <th class="long-text-column">دلیل خروج</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $presences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $presence): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td class="small-column"><?php echo e($presence->student_id ?? '-'); ?></td>
                <td><?php echo e($presence->student->first_name. ' '.$presence->student->last_name); ?> </td>

                <td class="time-column"><?php echo e($formatTime($presence->entry_time) ?? '-'); ?></td>

                <td class="time-column"><?php echo e($formatTime($presence->exit_time) ?? '-'); ?></td>

                <td class="long-text-column"><?php echo e($presence->delay_reason ?? '-'); ?></td>

                <td class="long-text-column"><?php echo e($presence->early_exit_reason ?? '-'); ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="7" class="text-center text-muted">
                    ❌ هیچ حضوری ثبت نشده است.
                </td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>

</body><?php /**PATH /home/lgroupir/public_html/pol-v2.tahlilfan.ir/backend/core/resources/views/components/presence-report.blade.php ENDPATH**/ ?>