<?php echo $__env->make('components.daily-report-presences-and-morals-report.daily-report-presences-and-morals-report-head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<body>
    <htmlpageheader name="page-header">
        <div>
            <div class="header-title">
                <?php echo e($reportInfo['school_title']); ?>

            </div>
            <table class="header-table">
                <tr>
                    <td style="width: 40%; text-align: right;">
                        تاریخ: <?php echo e($date); ?>

                        <br>
                        کد مدرسه: <?php echo e($reportInfo['school_code']); ?>

                    </td>

                    <td style="width: 20%; text-align: center; vertical-align: middle;">
                        <img src="<?php echo e(public_path('storage/schools/images/logo.png')); ?>"
                            class="header-logo"
                            alt="School Logo" />
                    </td>

                    <td style="width: 40%; text-align: left;">
                        نوع: <?php echo e($reportInfo['school_type']); ?>

                        <br>
                        استان: <?php echo e($reportInfo['school_province']); ?>

                        <br>
                        ناحیه: <?php echo e($reportInfo['school_district']); ?>

                    </td>
                </tr>
            </table>
        </div>
    </htmlpageheader>

    <div>
        <?php $__currentLoopData = $presences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bellId => $bellData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php $bell = $getBell($bellId) ?>
        <table class="bell-table">
            <tr>
                <td>
                    تاخیر و تعجیل
                </td>
                <td>
                    زنگ: <?php echo e($bell->title ?? '-'); ?>

                </td>

                <td>
                    ساعت شروع: <?php echo e($formatHour($bell?->started_at)); ?>

                </td>
                <td>
                    ساعت پایان: <?php echo e($formatHour($bell?->ended_at)); ?>

                </td>
            </tr>
        </table>

        <table class="presences-table">
            <thead>
                <tr>
                    <th class="col-shrink">ردیف</th>
                    <th>نام نام خانوادگی</th>
                    <th>تاخیر</th>
                    <th>تعجیل</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $bellData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $presence): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="col-shrink"><?php echo e($idx+1); ?></td>
                    <td><?php echo e($fullName($presence['student'])); ?></td>
                    <td><?php echo e($formatHour($presence['entry_time'])); ?></td>
                    <td><?php echo e($formatHour($presence['exit_time'])); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
        </table>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <?php $__currentLoopData = $morals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bellId => $bellData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php $bell = $getBell($bellId) ?>
        <table class="bell-table">
            <tr>
                <td>
                    وضعیت اخلاقی
                </td>

                <td>
                    زنگ: <?php echo e($bell->title ?? '-'); ?>

                </td>

                <td>
                    ساعت شروع: <?php echo e($formatHour($bell?->started_at)); ?>

                </td>
                <td>
                    ساعت پایان: <?php echo e($formatHour($bell?->ended_at)); ?>

                </td>
            </tr>
        </table>

        <table class="presences-table">
            <thead>
                <tr>
                    <th class="col-shrink">ردیف</th>
                    <th class="col-shrink">نام نام خانوادگی</th>
                    <th class="col-shrink">وضعیت</th>
                    <th>توضیحات</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $bellData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $moral): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="col-shrink"><?php echo e($idx+1); ?></td>
                    <td class="col-shrink"><?php echo e($fullName($moral['student'])); ?></td>
                    <td class="col-shrink"><?php echo e($getMoralStatusString($moral)); ?></td>
                    <td><?php echo e($moral['comment'] ?? '-'); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
        </table>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</body><?php /**PATH /home/lgroupir/public_html/pol-v2.tahlilfan.ir/backend/core/resources/views/components/daily-report-presences-and-morals-report/daily-report-presences-and-morals-report.blade.php ENDPATH**/ ?>