<?php echo $__env->make('components.student-grade-report.student-grade-report-head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<body>
    <?php $__currentLoopData = $studentGrades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $studentGrade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
    $classRoom = $studentGrade['school_session']['class_room'] ?? null;
    ?>

    <div class="report-card">
        <!-- header -->
        <table class="header-table">
            <tr>
                <td style="width: 25%; font-size: 10pt;">
                    کد مدرسه: <?php echo e($reportInfo['school_code']); ?><br>
                    استان: <?php echo e($reportInfo['school_province']); ?><br>
                    ناحیه: <?php echo e($reportInfo['school_district']); ?>

                </td>
                <td class="header-center">
                    <img class="logo-box" src="<?php echo e(public_path('storage/schools/images/logo.png')); ?>" />

                    <p style="margin: 0;"><?php echo e($reportInfo['school_title']); ?></p>
                </td>
                <td style="width: 25%; font-size: 10pt; text-align: left;">
                    از تاریخ: <?php echo e($gradeStartedAt()); ?><br>
                    تا تاریخ: <?php echo e($gradeEndedAt()); ?><br>
                    نوع: <?php echo e($reportInfo['school_type']); ?>

                </td>
            </tr>
        </table>

        <!-- information -->
        <table class="student-info-table">
            <tr>
                <td style="vertical-align: middle;">
                    <strong>کد کلاس:</strong> <?php echo e($classRoom['code'] ?? '-'); ?><br><br>
                    <strong>پایه:</strong> <?php echo e($classRoom['academic_level']['title'] ?? '-'); ?><br><br>
                    <strong>رشته:</strong> <?php echo e($classRoom['major']['title'] ?? '-'); ?><br><br>
                </td>
                <td style="vertical-align: middle;">
                    <strong>نام و نام خانوادگی:</strong> <?php echo e($fullName($studentGrade)); ?><br><br>
                    <strong>نام پدر:</strong> <?php echo e($fatherName($studentGrade)); ?><br><br>
                    <strong>کد ملی:</strong> <?php echo e($studentGrade['national_code'] ?? '-'); ?><br><br>
                </td>
                <td style="text-align: left;">
                    <div class="photo-container">
                        <!-- student image -->
                        <?php if(isset($studentGrade['image'])): ?>
                        <img
                            class="student-photo"
                            src="<?php echo e(storage_path('app/private/students/images/'. $studentGrade['image']['name'])); ?>" />
                        <?php else: ?>
                        <img
                            class="student-photo"
                            src="<?php echo e(resource_path('assets/images/avatar.png')); ?>" />
                        <?php endif; ?>
                    </div>
                </td>
            </tr>
        </table>

        <!-- table grades-->
        <table class="grades-table">
            <thead>
                <tr>
                    <th style="width: 40px;">ردیف</th>
                    <th>کد درس</th>
                    <th>نام درس</th>
                    <th>نمره نهایی</th>
                    <th>نتیجه</th>
                    <th>اساتید</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $studentGrade['grades']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $grade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class=<?php echo e($passingLesson($grade)?'':'failed-row'); ?>>
                    <td><?php echo e($idx + 1); ?></td>
                    <td><?php echo e($grade['lesson']['id'] ?? '-'); ?></td>
                    <td><?php echo e($grade['lesson']['title'] ?? '-'); ?></td>
                    <td><?php echo e($grade['grade']); ?></td>
                    <td><?php echo e($passingLesson($grade) ? 'قبول' : 'مردود'); ?></td>
                    <td><?php echo e($teacherFullName($grade)); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>

        <div class="gpa-box">
            معدل دوره: <?php echo e($finalGrade($studentGrade['grades'])); ?>

        </div>

        <!-- signature -->
        <table class="signature-table">
            <tr>
                <td>مهر و امضای معاون اجرایی</td>
                <td>مهر و امضای مدیریت آموزشگاه</td>
            </tr>
            <tr>
                <td>...........................</td>
                <td>...........................</td>
            </tr>
        </table>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</body><?php /**PATH /home/lgroupir/public_html/pol-v2.tahlilfan.ir/backend/core/resources/views/components/student-grade-report/student-grade-report.blade.php ENDPATH**/ ?>